using System;
using System.Collections;
using System.Configuration;
using System.Xml;
using System.Xml.XPath;
using System.Xml.Schema;
using System.Data;
using System.IO;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using System.Reflection;
using System.Diagnostics;
using System.Text;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL.HL7AL
{
 
		#region Header

		//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		//<Developers>
		//	<Developer>Brian    lin</Developer>
		//</Developers>
		//<SiteName>Hines OIFO</SiteName>
		//<CreationDate>3/27/2004</CreationDate>
		//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		//<summary></summary>

		#endregion

	/// <summary>
	/// CprsOrgMessage
	/// </summary>
	public class CprsOrgMessage
	{
		private const string ACK_MESSAGE_TYPE = "ORG^O20";
		private const string MESSAGE_TYPE = "OMG^O19";
		private const string CARRIAGE_RETURN = "\x0D";
		private static readonly string _msgDateTime = System.DateTime.Now.ToString("yyyyMMddhhmmsszzz").Replace(":","");
//		private static readonly string _msgControlID = "VBECS" + System.DateTime.Now.ToString("yMMddhhssffff");
		


		#region [Acknowledgement Message Methods]

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8277"> 
		///		<ExpectedInput>Valid CPRS New Order message</ExpectedInput>
		///		<ExpectedOutput>Non-null HL7OrgMessage.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8278"> 
		///		<ExpectedInput>Null value for original message input parameter</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Method used to create an Acknowledgement Error message.
		/// CR 2961
		/// </summary>
		/// <param name="originalMessage"></param>
		/// <param name="errorCode"></param>
		/// <param name="errorText"></param>
		/// <returns></returns>
		public static HL7OrgMessage AckError(HL7OmgMessage originalMessage, AckCodes errorCode, string errorText)
		{
			if( originalMessage == null )
				throw( new ArgumentNullException( "originalMessage" ) );
			if( originalMessage.GetMessageType() != MESSAGE_TYPE  )
				throw( new ArgumentException( "originalMessage" ) );

			// Split the error text on carriage returns. Only return first line to prevent
			// errors on the receiving side.
			string[] errorLines = errorText.Split(new char[]{'\r'});
			if( errorLines.Length > 0 )
			{
				errorText = errorLines[0];
			}
			// Split the error text on new lines. Only return first line to prevent
			// errors on the receiving side.
			string[] newLines = errorText.Split(new char[]{'\n'});
			if( newLines.Length > 0 )
			{
				errorText = newLines[0];
			}

			// Cut error text length to 255
			if( errorText.Length > 255 )
			{
				errorText = errorText.Remove( 255, errorText.Length - 255 );
				
			}

			// CR 2961
			HL7Interface intParms = new HL7Interface( InterfaceName.CPRS.ToString() );

			StringBuilder _ackError = new StringBuilder();
			_ackError.Append(BuildMSHSegment(intParms));
			_ackError.Append("MSA");
			_ackError.Append(intParms.FieldSeparator);
			_ackError.Append(errorCode);
			_ackError.Append(intParms.FieldSeparator);
			_ackError.Append(originalMessage.GetMessageControlID());
			_ackError.Append(intParms.FieldSeparator);
			_ackError.Append(errorText);
			_ackError.Append(CARRIAGE_RETURN);
			if ( (originalMessage.ORC.Length > 0) && (originalMessage.OrderControlCode != "PR") )
			{
				_ackError.Append(BuildHL7AckErrorORCSegment(intParms, originalMessage.ORC, errorText));
			}

			// CR 2961
			HL7ProtocolMessage _ackMessage = VbecsHL7Bridge.BuildHL7ProtocolMessage( _ackError.ToString() );

			return (HL7OrgMessage)_ackMessage;
		}

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8279"> 
		///		<ExpectedInput>Valid CPRS New Order message.</ExpectedInput>
		///		<ExpectedOutput>Non-null HL7OrgMessage.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8280"> 
		///		<ExpectedInput>Null original message input parameter.</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Method used to create an Acknowledgement Accept message.
		/// CR 2961
		/// </summary>
		/// <param name="originalMessage"></param>
		/// <param name="ocCode"></param>
		/// <param name="vbecsOrderNumber"></param>
		/// <returns></returns>
		public static HL7OrgMessage AppAcceptAck(HL7OmgMessage originalMessage, OrderControlCodes ocCode, int vbecsOrderNumber)
		{
			if( originalMessage == null )
				throw( new ArgumentNullException( "originalMessage" ) );
			if( originalMessage.GetMessageType() != MESSAGE_TYPE  )
				throw( new ArgumentException( "originalMessage" ) );
			if( vbecsOrderNumber < 1 )
				throw( new ArgumentOutOfRangeException( "vbecsOrderNumber" ) );

			HL7Interface intParms = new HL7Interface( InterfaceName.CPRS.ToString() );

			StringBuilder _ack = new StringBuilder();
			_ack.Append(BuildMSHSegment(intParms));
			_ack.Append("MSA");
			_ack.Append(intParms.FieldSeparator);
			_ack.Append(AckCodes.AA);
			_ack.Append(intParms.FieldSeparator);
			_ack.Append(originalMessage.GetMessageControlID());
			_ack.Append(CARRIAGE_RETURN);
			_ack.Append(BuildHL7AckPIDSegment( intParms, originalMessage.PID ) );
			_ack.Append(BuildHL7AckORCSegment(intParms, originalMessage.ORC, ocCode, vbecsOrderNumber));
			_ack.Append(BuildHL7AckOBRSegment(intParms, originalMessage.OBR, vbecsOrderNumber));

			// CR 2961
			HL7ProtocolMessage _ackMessage = VbecsHL7Bridge.BuildHL7ProtocolMessage( _ack.ToString() );

			return (HL7OrgMessage)_ackMessage;

		}

		#endregion

		#region [HL7 Acknowledgement Methods]

		private static string BuildMSHSegment(HL7Interface intParms)
		{

			StringBuilder _msh = new StringBuilder();
			_msh.Append("MSH");										// MSH Segment ID
			_msh.Append(intParms.FieldSeparator);					// Field Separator
			_msh.Append(intParms.EncodingCharacters);				// Encoding Characters
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.VbecsApplicationId.Trim());		// Sending Application
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.VbecsFacilityId.Trim());			// Sending Facility
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.InterfaceApplicationId.Trim());	// Receiving Application
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.InterfaceFacilityId.Trim());		// Receiving Facility
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(_msgDateTime);								// HL7 DateTime
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(ACK_MESSAGE_TYPE);							// HL7 Message Type
			_msh.Append(intParms.FieldSeparator);
			_msh.Append("VBECS" + System.DateTime.Now.ToString("yMMddhhssffff"));								// Message Control ID
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.ProcessingId);						// Processing ID
			_msh.Append(intParms.FieldSeparator);
			_msh.Append(intParms.VersionId.Trim());					// HL7 Version ID
			_msh.Append(CARRIAGE_RETURN);

			return _msh.ToString();
		}

        private static string BuildHL7AckPIDSegment( HL7Interface intParms, string[] pid)
        {
			string _patientICN = string.Empty;
			string _patientNumber = string.Empty;
			string _vistaPatientID = string.Empty;
            string _encChar69 = string.Empty;
            string _encChar1 = string.Empty;
            
            //CR 3509
            if (intParms.EncodingCharacters != null && intParms.EncodingCharacters.Length > 0 && pid.Length > 3)
            {
                if (intParms != null)
                {
                    if (intParms.EncodingCharacters != null)
                    {
                        if (intParms.EncodingCharacters.Length > 0)
                        {
                            if (intParms.EncodingCharacters[0] != Char.MinValue)
                            {
                                var ch = intParms.EncodingCharacters[0];

                                _encChar69 = ch.ToString();
                            }
                            else
                            {
                                _encChar69 = string.Empty;
                            }
                        }
                    }
                }
                _encChar1 = intParms.EncodingCharacters != null ? intParms.EncodingCharacters[1].ToString() : string.Empty;
                string[] patientIdList = HL7Utility.ParseGetStringArray(pid[3],
                    _encChar1);
                for (int i = 0; i < patientIdList.Length; i++)
                {
                    
                    string[] idComponent = HL7Utility.ParseGetStringArray(patientIdList[i],
                       _encChar69);
                    switch (idComponent[4].ToString())
                    {
                        case "NI":
                            _patientICN = HL7Utility.ConvertString(idComponent[0]);
                            break;

                        case "SS":
                            _patientNumber = HL7Utility.ConvertString(idComponent[0]);
                            break;

                        case "PI":
                            _vistaPatientID = HL7Utility.ConvertString(idComponent[0]);
                            break;
                    }
                }
            }
            else
            {
                throw (new ArgumentNullException("intParms"));
            }
            StringBuilder _pid = new StringBuilder();
            _pid.Append("PID");
            _pid.Append(intParms.FieldSeparator);
            _pid.Append(intParms.FieldSeparator);
            _pid.Append(intParms.FieldSeparator);

// CPRS only accepts the VistA Patient IEN.  Keep for future use/reference

            _pid.Append(_patientICN);
            //CR 3509
            try
            {
                if (intParms != null && intParms.EncodingCharacters != null && intParms.EncodingCharacters.Length > 0)
                {
                    for (int i = 0; i <= 3; i++)
                        _pid.Append(_encChar69);
                        
                        
                    _pid.Append("NI");
                    _pid.Append(_encChar1);
                    _pid.Append(_patientNumber);
                    
                    for (int i = 0; i <= 3; i++)
                        _pid.Append(_encChar69);

                    _pid.Append("SS");
                    _pid.Append(_encChar1);
                    _pid.Append(_vistaPatientID);

                    for (int i = 0; i <= 3; i++)
                        _pid.Append(_encChar69);

                    _pid.Append("PI");

                    _pid.Append(_vistaPatientID);
                    _pid.Append(intParms.FieldSeparator);
                    _pid.Append(intParms.FieldSeparator);
                    string[] patientName = HL7Utility.ParseGetStringArray(pid[5],
                        _encChar69);
                    for (int i = 0; i < patientName.Length; i++)
                    {
                        if (i == 0)
                        {
                            _pid.Append(patientName[0].ToString());
                            _pid.Append(_encChar69);
                        }
                        if (i == 1)
                        {
                            _pid.Append(patientName[1].ToString());
                            _pid.Append(_encChar69);
                        }
                        if (i == 2)
                        {
                            _pid.Append(patientName[2].ToString());
                        }
                    }
                }
                else
                {
                    throw (new ArgumentNullException("intParms"));
                }
            }
            catch (NullReferenceException)
            {
                throw (new ArgumentNullException("intParms"));
            }

            _pid.Append(intParms.FieldSeparator);
            _pid.Append(intParms.FieldSeparator);
            _pid.Append(pid[7].ToString());
            _pid.Append(intParms.FieldSeparator);
            _pid.Append(pid[8].ToString());
            _pid.Append(CARRIAGE_RETURN);

            return _pid.ToString();
        }

        private static string BuildHL7AckORCSegment(HL7Interface intParms, string[] orc, OrderControlCodes OrderControlID, int VbecsOrderNumber)
        {
            string _encChar0 = string.Empty;
            
            StringBuilder _orc = new StringBuilder();
            _orc.Append("ORC");
            _orc.Append(intParms.FieldSeparator);
            _orc.Append(OrderControlID);
            _orc.Append(intParms.FieldSeparator);
            //CR 3509
            if (intParms.EncodingCharacters != null && intParms.EncodingCharacters.Length > 0)
            {
                if (intParms != null)
                {
                    if (intParms.EncodingCharacters != null)
                    {
                        if (intParms.EncodingCharacters.Length > 0)
                        {
                            if (intParms.EncodingCharacters[0] != Char.MinValue)
                            {
                                var ch = intParms.EncodingCharacters[0];

                                _encChar0 = ch.ToString();
                            }
                            else
                            {
                                _encChar0 = string.Empty;
                            }
                        }
                    }
                }
                string[] cprsOrderNumber = orc[2].Split(intParms.EncodingCharacters[0]);
                if (cprsOrderNumber.Length > 1)
                {
                    _orc.Append(cprsOrderNumber[0].ToString());
                    _orc.Append(_encChar0);
                    _orc.Append(cprsOrderNumber[1].ToString());
                    _orc.Append(intParms.FieldSeparator);
                    _orc.Append(VbecsOrderNumber);
                    _orc.Append(_encChar0);
                    _orc.Append("VBEC");
                    _orc.Append(intParms.FieldSeparator);
                }
                else
                {
                    throw (new ArgumentNullException("orc"));
                }
                string[] cprsGroupNumber = orc[4].Split(intParms.EncodingCharacters[0]);
                if (cprsGroupNumber.Length > 1)
                {
                    _orc.Append(cprsGroupNumber[0].ToString());
                    _orc.Append(_encChar0);
                    _orc.Append(cprsGroupNumber[1].ToString());
                    _orc.Append(CARRIAGE_RETURN);
                }
                else
                {
                    throw (new ArgumentNullException("orc"));
                }
            }
            else
            {
                throw (new ArgumentNullException("intParms"));
            }
            return _orc.ToString();
        }

		private static string BuildHL7AckErrorORCSegment(HL7Interface intParms, string[] orc, string errorText)
		{
			StringBuilder _orc = new StringBuilder();
            string _encChar0 = string.Empty;
			_orc.Append("ORC");
			_orc.Append(intParms.FieldSeparator);
			_orc.Append("UA");
			_orc.Append(intParms.FieldSeparator);
             //CR 3509
            if (intParms.EncodingCharacters != null && intParms.EncodingCharacters.Length > 0)
		    {
                if (intParms != null)
                {
                    if (intParms.EncodingCharacters != null)
                    {
                        if (intParms.EncodingCharacters.Length > 0)
                        {
                            if (intParms.EncodingCharacters[0] != Char.MinValue)
                            {
                                var ch = intParms.EncodingCharacters[0];

                                _encChar0 = ch.ToString();
                            }
                            else
                            {
                                _encChar0 = string.Empty;
                            }
                        }
                    }
                }
                string[] cprsOrderNumber = orc[2].Split(intParms.EncodingCharacters[0]);
		        if (cprsOrderNumber.Length > 1)
		        {
		            _orc.Append(cprsOrderNumber[0].ToString());
                    _orc.Append(_encChar0);
		            _orc.Append(cprsOrderNumber[1].ToString());
		            _orc.Append(intParms.FieldSeparator);
                    _orc.Append(_encChar0);
		            _orc.Append("VBEC");
		            _orc.Append(intParms.FieldSeparator);
		        }
                else
                {
                    throw (new ArgumentNullException("orc"));
                }
                string[] cprsGroupNumber = orc[4].Split(intParms.EncodingCharacters[0]);
		        if (cprsGroupNumber.Length > 1)
		        {
		            _orc.Append(cprsGroupNumber[0].ToString());
                    _orc.Append(_encChar0);
		            _orc.Append(cprsGroupNumber[1].ToString());
		            _orc.Append(intParms.FieldSeparator);
		            _orc.Append("UA");
		            _orc.Append(intParms.FieldSeparator);
		            _orc.Append(intParms.FieldSeparator);
		            _orc.Append(intParms.FieldSeparator);
		            _orc.Append(intParms.FieldSeparator);
		            _orc.Append(intParms.FieldSeparator);
		            _orc.Append(intParms.FieldSeparator);
		            _orc.Append(intParms.FieldSeparator);
		            _orc.Append(intParms.FieldSeparator);
		            _orc.Append(intParms.FieldSeparator);
		            _orc.Append(intParms.FieldSeparator);
		            _orc.Append(intParms.FieldSeparator);
                    _orc.Append(_encChar0);
		            _orc.Append(errorText);
		            _orc.Append(CARRIAGE_RETURN);
		        }
                else
                {
                    throw (new ArgumentNullException("orc"));
                }
		    }
            else
            {
                throw (new ArgumentNullException("intParms"));
            }
		    return _orc.ToString();
		}

        private static string BuildHL7AckOBRSegment(HL7Interface intParms, string[] obr, int VbecsOrderNumber)
        {
            StringBuilder _obr = new StringBuilder();
            string _encChar0 = string.Empty;
            
            
            _obr.Append("OBR");
            _obr.Append(intParms.FieldSeparator);
            _obr.Append("1");
            _obr.Append(intParms.FieldSeparator);
             //CR 3509
            if (intParms.EncodingCharacters != null && intParms.EncodingCharacters.Length > 0)
            {
                if (intParms != null)
                {
                    if (intParms.EncodingCharacters != null)
                    {
                        if (intParms.EncodingCharacters.Length > 0)
                        {
                            if (intParms.EncodingCharacters[0] != Char.MinValue)
                            {
                                var ch = intParms.EncodingCharacters[0];

                                _encChar0 = ch.ToString();
                            }
                            else
                            {
                                _encChar0 = string.Empty;
                            }
                        }
                    }
                }
                string[] cprsOrderNumber = obr[2].Split(intParms.EncodingCharacters[0]);
                if (cprsOrderNumber.Length > 1)
                {
                    _obr.Append(cprsOrderNumber[0].ToString());
                    _obr.Append(_encChar0);
                    _obr.Append(cprsOrderNumber[1].ToString());
                    _obr.Append(intParms.FieldSeparator);
                    _obr.Append(VbecsOrderNumber);
                    _obr.Append(_encChar0);
                    _obr.Append("VBEC");
                    _obr.Append(intParms.FieldSeparator);
                }
                else
                {
                    throw (new ArgumentNullException("obr"));
                }
                string[] universalServiceID = obr[4].Split(intParms.EncodingCharacters[0]);
                if (universalServiceID.Length > 2)
                {
                    _obr.Append(universalServiceID[0].ToString());
                    _obr.Append(_encChar0);
                    _obr.Append(universalServiceID[1].ToString());
                    _obr.Append(_encChar0);
                    _obr.Append(universalServiceID[2].ToString());
                }
                else
                {
                    throw (new ArgumentNullException("obr"));
                }
                // check if this is a component and has special instructions to include
                if (universalServiceID.Length > 3)
                {
                    _obr.Append(_encChar0);
                    _obr.Append(_encChar0);
                    _obr.Append(universalServiceID[4].ToString());
                }
                else
                {
                    throw (new ArgumentNullException("obr"));
                }
                _obr.Append(CARRIAGE_RETURN);
            }
            else
            {
                throw (new ArgumentNullException("intParms"));
            }
           
            
            return _obr.ToString();
        }
        #endregion
    }
}
